/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.packet;

import com.simibubi.create.Create;
import com.simibubi.create.content.schematics.block.SchematicTableContainer;
import com.simibubi.create.content.schematics.block.SchematicTableTileEntity;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.function.Supplier;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class SchematicUploadPacket
extends SimplePacketBase {
    public static final int BEGIN = 0;
    public static final int WRITE = 1;
    public static final int FINISH = 2;
    private int code;
    private long size;
    private String schematic;
    private byte[] data;

    public SchematicUploadPacket(int code, String schematic) {
        this.code = code;
        this.schematic = schematic;
    }

    public static SchematicUploadPacket begin(String schematic, long size) {
        SchematicUploadPacket pkt = new SchematicUploadPacket(0, schematic);
        pkt.size = size;
        return pkt;
    }

    public static SchematicUploadPacket write(String schematic, byte[] data) {
        SchematicUploadPacket pkt = new SchematicUploadPacket(1, schematic);
        pkt.data = data;
        return pkt;
    }

    public static SchematicUploadPacket finish(String schematic) {
        return new SchematicUploadPacket(2, schematic);
    }

    public SchematicUploadPacket(class_2540 buffer) {
        this.code = buffer.readInt();
        this.schematic = buffer.method_10800(256);
        if (this.code == 0) {
            this.size = buffer.readLong();
        }
        if (this.code == 1) {
            this.data = buffer.method_10795();
        }
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.writeInt(this.code);
        buffer.method_10814(this.schematic);
        if (this.code == 0) {
            buffer.writeLong(this.size);
        }
        if (this.code == 1) {
            buffer.method_10813(this.data);
        }
    }

    @Override
    public void handle(Supplier<SimplePacketBase.Context> context) {
        context.get().enqueueWork(() -> {
            class_3222 player = ((SimplePacketBase.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            if (this.code == 0) {
                class_2338 pos = ((SchematicTableTileEntity)((SchematicTableContainer)player.field_7512).contentHolder).method_11016();
                Create.SCHEMATIC_RECEIVER.handleNewUpload(player, this.schematic, this.size, pos);
            }
            if (this.code == 1) {
                Create.SCHEMATIC_RECEIVER.handleWriteRequest(player, this.schematic, this.data);
            }
            if (this.code == 2) {
                Create.SCHEMATIC_RECEIVER.handleFinishedUpload(player, this.schematic);
            }
        });
        context.get().setPacketHandled(true);
    }
}

